<?php

namespace Drupal\commerce_usps;

/**
 * USPS SDK factory interface.
 */
interface USPSSdkFactoryInterface {

  /**
   * API url for test usage.
   */
  const USPS_INTEGRATION_BASE_URL = 'https://apis-tem.usps.com';

  /**
   * API url for production usage.
   */
  const USPS_PRODUCTION_BASE_URL = 'https://apis.usps.com';

  /**
   * Token key for storage API.
   */
  const TOKEN_KEY = 'commerce_usps.oauth2_token';

  /**
   * Retrieves the USPS SDK for the given config.
   *
   * @param array $api_information
   *   An associative array, containing at least these three keys:
   *   - mode: The API mode (e.g "test" or "live").
   *   - client_id: The client ID.
   *   - secret: The client secret.
   */
  public function get(array $api_information): USPSSdkInterface;

}
