<?php

namespace Drupal\commerce_usps;

use CommerceGuys\Addressing\AddressInterface;
use Drupal\commerce_shipping\Entity\ShipmentInterface;
use GuzzleHttp\ClientInterface;
use Psr\Http\Message\ResponseInterface;

/**
 * Provides an interface of the USPS SDK.
 */
interface USPSSdkInterface {

  /**
   * Url for access token request.
   */
  const USPS_ACCESS_TOKEN_URL = '/oauth2/v3/token';

  /**
   * Url for rate request.
   */
  const USPS_API_RATE_URL = '/shipments/v3/options/search';

  /**
   * Sets client for USPS SDK instance.
   *
   * @param \GuzzleHttp\ClientInterface $client
   *   The client.
   */
  public function setClient(ClientInterface $client): void;

  /**
   * Provides configuration for USPS SDK instance.
   *
   * @param array $config
   *   Instance configurations.
   */
  public function setConfiguration(array $config): void;

  /**
   * Provides options for the rate request.
   *
   * @param array $rate_options
   *   The rate options.
   */
  public function setRateOptions(array $rate_options): void;

  /**
   * Gets an access token.
   */
  public function getAccessToken(): ResponseInterface;

  /**
   * Sets the shipment property.
   *
   * @param \Drupal\commerce_shipping\Entity\ShipmentInterface $shipment
   *   The shipment.
   */
  public function setShipment(ShipmentInterface $shipment): void;

  /**
   * Gets a list of rates from request.
   */
  public function getShipmentRates(): array;

  /**
   * Sets the log process property.
   *
   * @param bool $log_request
   *   Whether we should write logs on request.
   * @param bool $log_response
   *   Whether we should write logs on response.
   */
  public function setLogProcess(bool $log_request = FALSE, bool $log_response = FALSE): void;

  /**
   * Whether the destination country is domestic.
   *
   * @param \CommerceGuys\Addressing\AddressInterface $address
   *   The shipment destination address.
   */
  public function isDomesticCountry(AddressInterface $address): bool;

}
