<?php

namespace Drupal\Tests\commerce_usps\Kernel;

use CommerceGuys\Addressing\Address;

/**
 * Tests domestic rate related functionality.
 */
class USPSDomesticRateRequestTest extends USPSRateRequestTestBase {

  /**
   * {@inheritdoc}
   *
   * @dataProvider dataProviderCreateFilteredRates
   */
  public function testFilteredRates(string $property_key, array $property_values, ?string $price_type = NULL) {
    parent::testFilteredRates($property_key, $property_values, $price_type);
  }

  /**
   * Data provider for testFilteredRates.
   *
   * @return \Generator
   *   The test data.
   */
  public static function dataProviderCreateFilteredRates() {
    yield ['categories', ['MACHINABLE']];
    yield ['facility_types', ['DESTINATION_DELIVERY_UNIT'], 'commercial'];
    yield ['rate_indicators', ['SP']];
  }

  /**
   * {@inheritdoc}
   */
  protected function getMailClass(): string {
    return 'all_outbound';
  }

  /**
   * {@inheritdoc}
   */
  protected function getDeliveryAddress(): Address {
    return new Address('US', 'CO', 'Morrison', '', 80465, '', '18300 W Alameda Pkwy');
  }

  /**
   * {@inheritdoc}
   */
  protected function getPluginId(): string {
    return 'usps';
  }

  /**
   * {@inheritdoc}
   */
  protected function getListOfServices(): array {
    return [
      'MEDIA_MAIL',
      'LIBRARY_MAIL',
      'PARCEL_SELECT',
      'USPS_CONNECT_LOCAL',
      'PRIORITY_MAIL',
      'BOUND_PRINTED_MATTER',
    ];
  }

}
