<?php

namespace Drupal\Tests\commerce_usps\Kernel;

use CommerceGuys\Addressing\Address;

/**
 * Tests international rate related functionality.
 */
class USPSInternationalRateRequestTest extends USPSRateRequestTestBase {

  /**
   * {@inheritdoc}
   *
   * @dataProvider dataProviderCreateFilteredRates
   */
  public function testFilteredRates(string $property_key, array $property_values, ?string $price_type = NULL) {
    parent::testFilteredRates($property_key, $property_values, $price_type);
  }

  /**
   * Data provider for testFilteredRates.
   *
   * @return \Generator
   *   The test data.
   */
  public static function dataProviderCreateFilteredRates() {
    yield ['categories', ['FLATS']];
    yield ['rate_indicators', ['SP']];
  }

  /**
   * {@inheritdoc}
   */
  protected function getMailClass(): string {
    return 'all';
  }

  /**
   * {@inheritdoc}
   */
  protected function getDeliveryAddress(): Address {
    return new Address('GB', 'London', 'Pimlico', '', 'SW1V 3EN', '', '113 Lupus St.');
  }

  /**
   * {@inheritdoc}
   */
  protected function getPluginId(): string {
    return 'usps_international';
  }

  /**
   * {@inheritdoc}
   */
  protected function getListOfServices(): array {
    return [
      'GLOBAL_EXPRESS_GUARANTEED',
      'PRIORITY_MAIL_INTERNATIONAL',
      'PRIORITY_MAIL_EXPRESS_INTERNATIONAL',
    ];
  }

}
