(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.commerceMiaQrCodeCheckout = {
    attach: function (context, settings) {
      const $checkoutQrCode = $(once('checkout-mia-qr-code', '.checkout-mia-qr-code', context));
      $checkoutQrCode.each(function () {
        if(Drupal.behaviors.commerceMiaQrCodeCheckout.isMobile()) {
          $('.checkout-mia-qr-code-link').show();
          $('.checkout-mia-qr-code-image').hide();
        } else {
          $('.checkout-mia-qr-code-link').hide();
          $('.checkout-mia-qr-code-image').show();
        }
        const timerElement = $(this).find('[data-timing]');
        const minutes = parseInt(timerElement.data('timing'));
        let totalSeconds = minutes * 60;
        // We decrease some seconds for invalidation.
        totalSeconds -= 20;

        function formatTime(seconds) {
          const mins = Math.floor(seconds / 60);
          const secs = seconds % 60;
          return `${mins}:${secs.toString().padStart(2, '0')}`;
        }

        Drupal.behaviors.commerceMiaQrCodeCheckout.timerCheck = setInterval(() => {

          const ajax = Drupal.ajax({
            url: '/vicb-qr-code-checkout-status/' + drupalSettings.commerce_miq_qr_code.uuid,
          });
          ajax.execute();
        }, 3500);

        Drupal.behaviors.commerceMiaQrCodeCheckout.timerId = setInterval(() => {
          if (totalSeconds <= 0) {
            clearInterval(Drupal.behaviors.commerceMiaQrCodeCheckout.timerId);

            return;
          }
          totalSeconds--;
          timerElement.text(formatTime(totalSeconds));
        }, 1000);

      });
    },
    isMobile: function () {
      const ua = navigator.userAgent.toLowerCase();
      return /android|iphone|ipad|ipod/.test(ua);
    }

  };
  $.fn.commerceMiaQrCodeCheckout_disableRequest = function () {
    clearInterval(Drupal.behaviors.commerceMiaQrCodeCheckout.timerId);
    clearInterval(Drupal.behaviors.commerceMiaQrCodeCheckout.timerCheck);
  };

})(jQuery, Drupal, drupalSettings);
