<?php

namespace Drupal\commerce_vicb_mia\Form;

use Drupal;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class ReconciliationTransactionsForm extends FormBase {

  public function getFormId() {
    return 'commerce_vicb_mia_reconciliation_transactions';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $request = Drupal::request();

    $form['datefrom'] = [
      '#type' => 'date',
      '#title' => $this->t('Date from'),
      '#default_value' => $request->query->get('datefrom', date('Y-m-d')),
    ];
    $form['dateto'] = [
      '#type' => 'date',
      '#title' => $this->t('Date to'),
      '#default_value' => $request->query->get('dateto', date('Y-m-d')),
    ];
    $form['actions'] = [
      '#type' => 'actions',
    ];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
      '#attributes' => [
        'class' => [
          'button button--primary',
        ]
      ]
    ];
    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $routeMatch = \Drupal::routeMatch();

    $form_state->setRedirect($routeMatch->getRouteName(), [
      'commerce_payment_gateway' => $routeMatch->getRawParameter('commerce_payment_gateway'),
      'datefrom' => $form_state->getValue('datefrom'),
      'dateto' => $form_state->getValue('dateto'),
    ] );
  }

}
