<?php

namespace Drupal\commerce_vicb_mia\Controller;

use Drupal\commerce_vicb_mia\Plugin\Commerce\PaymentGateway\VicbMiaQrCodePaymentGateway;
use Drupal\commerce_vicb_mia\VicbMiaQrCodeCheckoutOrderManager;
use Drupal\commerce_vicb_mia\VicbMiaQrCodeClient;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\InvokeCommand;
use Drupal\Core\Ajax\MessageCommand;
use Drupal\Core\Ajax\RedirectCommand;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;

class CheckoutQrCodeStatusController extends ControllerBase {

  private VicbMiaQrCodeCheckoutOrderManager $vicbMiaQrCodeCheckoutOrderManager;

  public function __construct(VicbMiaQrCodeCheckoutOrderManager $vicbMiaQrCodeCheckoutOrderManager) {
    $this->vicbMiaQrCodeCheckoutOrderManager = $vicbMiaQrCodeCheckoutOrderManager;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('commerce_vicb_mia.qr_code.checkout_order_manager')
    );
  }

  public function index($uuid) {
    $response = new AjaxResponse();
    $orders = $this->entityTypeManager()->getStorage('commerce_order')->loadByProperties(['uuid' => $uuid]);
    if (!$orders) {
      return $response;
    }
    /** @var \Drupal\commerce_order\Entity\OrderInterface $order */
    $order = array_shift($orders);
    /** @var \Drupal\commerce_payment\Entity\PaymentGatewayInterface $payment_gateway */
    $payment_gateway = $order->get('payment_gateway')->entity;

    $payment_gateway_plugin = $payment_gateway->getPlugin();
    if (!$payment_gateway_plugin instanceof VicbMiaQrCodePaymentGateway) {
      return $response;
    }
    try {
      $status = $this->vicbMiaQrCodeCheckoutOrderManager->statusQrCode($order, $payment_gateway_plugin);

      $qrCodeStatus = $status['status'];
      switch ($qrCodeStatus) {
        case VicbMiaQrCodeClient::STATUS_EXPIRED:
          $response->addCommand(new MessageCommand('QR Code expired, please refresh page to generate other QR Code', NULL, ['type' => 'warning']));
          $response->addCommand(new InvokeCommand('body', 'commerceMiaQrCodeCheckout_disableRequest', []));
          break;
        case VicbMiaQrCodeClient::STATUS_PAID:
          $response->addCommand(new InvokeCommand('body', 'commerceMiaQrCodeCheckout_disableRequest', []));

          $url = Url::fromRoute('commerce_checkout.form', [
            'commerce_order' => $order->id(),
            'step' => $order->get('checkout_step')->value,
          ])->toString();
          $response->addCommand(new RedirectCommand($url));
          break;
      }
    } catch (\Exception $e) {

      $response->addCommand(new InvokeCommand('body', 'commerceMiaQrCodeCheckout_disableRequest', []));
    }


    return $response;
  }

}
