<?php

namespace Drupal\commerce_vicb_mia\Plugin\Commerce\PaymentMethodType;

use Drupal\commerce_payment\Annotation\CommercePaymentMethodType;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\PaymentMethodTypeBase;

/**
 * Provides the VictoriaBank payment method type.
 *
 * @CommercePaymentMethodType(
 *   id = "vicb_mia_qr_code",
 *   label = @Translation("Victoria Bank Mia Qr Code"),
 *   create_label = @Translation("New Victoria Bank Mia Qr Code")
 * )
 */
class VicbMiaQrCodeMethodType extends PaymentMethodTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    return 'Victoria Bank Mia Qr Code';
  }

}
