<?php

namespace Drupal\commerce_vicb_mia\Controller;

use Drupal\commerce_vicb_mia\Form\ReconciliationTransactionsForm;

use Drupal\commerce_vicb_mia\Plugin\Commerce\PaymentGateway\VicbMiaQrCodePaymentGatewayInterface;
use Drupal\commerce_vicb_mia\VicbMiaQrCodeClient;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Session\AccountInterface;
use Symfony\Component\HttpFoundation\Request;

class ReconciliationTransactionsController extends ControllerBase {

  public function index(Request $request) {
    $commerce_payment_gateway = \Drupal::routeMatch()->getParameter('commerce_payment_gateway');
    /** @var VicbMiaQrCodePaymentGatewayInterface $commercePaymentGatewayPlugin */
    $commercePaymentGatewayPlugin = $commerce_payment_gateway->getPlugin();
    $client = (new VicbMiaQrCodeClient($commercePaymentGatewayPlugin->apiUrl(), $commercePaymentGatewayPlugin->apiUsername(), $commercePaymentGatewayPlugin->apiPassword()));
    $table = [];
    $dateFrom = $request->query->get('datefrom');
    $dateTo = $request->query->get('dateto');
    if($dateFrom && $dateTo){
      $reconciliationTransactionsList = $client->getReconciliationTransactions($dateFrom, $dateTo);
      $transactionsInfo = $reconciliationTransactionsList['transactionsInfo'] ?? [];
      $header = [];
      if(!empty($transactionsInfo)){
        $header = array_keys($transactionsInfo[0]);
        $rows = [];
        foreach ($transactionsInfo as $transactionInfo) {
          $rows[] = array_values($transactionInfo);
        }
        $table = [
          '#theme' => 'table',
          '#header' => $header,
          '#rows' => $rows,
        ];
      }
    }

    return [
      '#type' => 'inline_template',
      '#template' => '{{form}}{{table}}',
      '#context' => [
        'form' => $this->formBuilder()->getForm(ReconciliationTransactionsForm::class),
        'table' => $table,
      ]
    ];
  }

  /**
   * Checks access for a specific request.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   Run access checks for this account.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(AccountInterface $account) {
    if(!$account->hasPermission('administer commerce_payment_gateway')) {
      return AccessResult::forbidden();
    }
    $commerce_payment_gateway = \Drupal::routeMatch()->getParameter('commerce_payment_gateway');

    if($commerce_payment_gateway->getPlugin() instanceof VicbMiaQrCodePaymentGatewayInterface)
    {
      return AccessResult::allowed();
    }

    return AccessResult::forbidden();
  }

}
