<?php

namespace Drupal\commerce_vicb_mia\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\SupportsRefundsInterface;
use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\SupportsStoredPaymentMethodsInterface;

interface VicvMiaQrCodePaymentGatewayInterface extends SupportsRefundsInterface, SupportsStoredPaymentMethodsInterface {

  const URL_TEST = 'https://test-ipspj.victoriabank.md/';

  const URL_LIVE = 'https://ips-api-pj.vb.md/';

  /**
   *
   * @return string The API URL.
   */
  public function apiUrl(): string;

  /**
   *
   * @return string The API username.
   */
  public function apiUsername(): string;

  /**
   *
   * @return string The API password.
   */
  public function apiPassword(): string;

  /**
   *
   * @return int The timing information extracted or processed related to a QR code.
   */
  public function qrCodeTiming(): int;

  /**
   *
   * @return string The creditor account information.
   */
  public function creditorAccount(): string;

  /**
   *
   * @return string The name of the company.
   */
  public function companyName(): string;

}
