# Commerce Wallee

A Drupal Commerce module that provides integration with the Wallee payment gateway.

## Description

Commerce Wallee integrates Drupal Commerce with the Wallee payment processing platform, offering secure payment processing, tokenization, and comprehensive payment management capabilities.

## Requirements

- Drupal 10.5+ or Drupal 11
- Drupal Commerce 3.x
- PHP 8.0+
- Wallee SDK 4.8+

## Installation

1. **Install via Composer (Recommended):**
   ```bash
   composer require drupal/commerce_wallee
   ```

2. **Enable the module:**
   ```bash
   drush en commerce_wallee
   ```

3. **Configure the payment gateway:**
   - Navigate to Commerce → Configuration → Payment gateways
   - Add a new Wallee payment gateway
   - Configure your Wallee credentials (Space ID, User ID, API Key), you got this information from PHP SDK integration

## Features

- **Payment Gateway Integration**: Seamless integration with Wallee payment processing
- **Tokenization Support**: Secure storage of payment methods for recurring transactions
- **Checkout Integration**: Custom checkout panes for payment information and terms agreement
- **Webhook Support**: Real-time payment status updates via webhooks

## Configuration

### Token Configuration

If you're using payment tokenization:
- Configure token settings in the payment gateway configuration
- Set up tokenization modes according to your business requirements

## Upgrade Instructions

### ⚠️ IMPORTANT: Version 3 Upgrade

When upgrading to Commerce Wallee version 3, you **MUST** uninstall and reinstall the entire module due to significant architectural changes.

**Upgrade Process:**
1. **Backup your configuration (Space ID, User ID, Secret) and data**
2. **Uninstall the module:**
   ```bash
   drush pmu commerce_wallee
   ```
3. **Clear all caches:**
   ```bash
   drush cr
   ```
4. **Reinstall the module:**
   ```bash
   drush en commerce_wallee
   ```
5. **Reconfigure your payment gateway settings**
6. **Change your webhook URL on your Webhook configuration (Wallee backend)**

### Token Migration

If you were using payment tokens in previous versions:
- **Tokens will NOT be automatically migrated to the new payment method entity**
- You must manually migrate token configurations in the plugin configuration (Migrate payment methods)
- Verify that existing tokens are still accessible after reconfiguration

## Development

### Hooks and Events

The module provides several hooks for custom integrations:

- `hook_commerce_wallee_address()`: Alter address data before sending to Wallee
- `hook_commerce_wallee_alter_transaction()`: Modify transaction payload
- `hook_commerce_wallee_alter_transaction_token()`: Customize token-based transactions

## Troubleshooting

### Common Issues

1. **Payment Gateway Not Appearing:**
   - Ensure Drupal Commerce is properly installed
   - Check that all dependencies are met
   - Verify module is enabled

2. **API Connection Errors:**
   - Verify your Wallee credentials
   - Check network connectivity
   - Ensure correct environment settings (test vs production)

3. **Token Issues After Upgrade:**
   - Reconfigure token settings in payment gateway
   - Verify token storage configuration
   - Check for any custom token handling code

### Debug Mode

Enable debug logging in your payment gateway configuration to troubleshoot issues.

## Support

- **Documentation**: Check the module's documentation for detailed configuration options
- **Issues**: Report bugs and feature requests through the project's issue queue


## Contributing

Contributions are welcome! Please ensure your code follows Drupal coding standards and includes proper documentation.

---

**Note**: Always test upgrades in a development environment before applying to production. Backup your data and configuration before any major version changes.
