<?php

namespace Drupal\commerce_wstack\EventSubscriber;

use Drupal\Component\EventDispatcher\Event;

/**
 * Event that is triggered in case of an incoming webhook.
 */
class WebhookEvent extends Event {

  /**
   * The Webhook data.
   *
   * @var array
   */
  protected array $data;

  /**
   * Flag to prevent further processing.
   *
   * @var bool
   */
  protected bool $isProcessed = FALSE;

  /**
   * Construct a new WebhookEvent class.
   *
   * @param array $data
   *   The webhook data.
   */
  public function __construct(array $data) {
    $this->data = $data;
  }

  /**
   * The webhook data.
   *
   * @return array
   *   The webhook data.
   */
  public function getData(): array {
    return $this->data;
  }

  /**
   * Whether the webhook should be further processed.
   *
   * @return bool
   *   The flag to prevent further processing.
   */
  public function isProcessed(): bool {
    return $this->isProcessed;
  }

  /**
   * Set the flag to prevent further processing.
   *
   * @param bool $isProcessed
   *   The flag to prevent further processing.
   */
  public function setIsProcessed(bool $isProcessed): void {
    if ($isProcessed) {
      $this->stopPropagation();
    }
    $this->isProcessed = $isProcessed;
  }

}
