<?php

namespace Drupal\commerce_wstack\Plugin\Commerce\PaymentMethodType;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\commerce_payment\Attribute\CommercePaymentMethodType;
use Drupal\commerce_payment\Plugin\Commerce\PaymentMethodType\PaymentMethodTypeBase;
use Drupal\commerce_payment\Entity\PaymentMethodInterface;
use Drupal\entity\BundleFieldDefinition;

/**
 * Provides the wtype payment method type.
 */
#[CommercePaymentMethodType(
  id: "wtype",
  label: new TranslatableMarkup('WType'),
)]
class WType extends PaymentMethodTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildLabel(PaymentMethodInterface $payment_method) {
    $card_name = $payment_method->card_name->value ?? '';
    $card_type = $payment_method->card_type->value ?? 'wtype';
    $card_number = $payment_method->card_number->value ?? '';

    if ($card_number) {
      return $this->t('@number (@name)', [
        '@name' => $card_name,
        '@number' => $card_number,
      ]);
    }

    return $this->t('WType @type', ['@type' => $card_type]);
  }

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    $fields['card_version_id'] = BundleFieldDefinition::create('integer')
      ->setLabel($this->t('Version ID'))
      ->setDescription($this->t('The version ID.'))
      ->setSetting('size', 'normal');

    $fields['card_type'] = BundleFieldDefinition::create('string')
      ->setLabel($this->t('WType Type'))
      ->setDescription($this->t('The WType type.'));

    $fields['card_name'] = BundleFieldDefinition::create('string')
      ->setLabel($this->t('WType Name'))
      ->setDescription($this->t('The WType name.'));

    $fields['card_number'] = BundleFieldDefinition::create('string')
      ->setLabel($this->t('WType Number'))
      ->setDescription($this->t('The WType number.'));

    $fields['card_exp_month'] = BundleFieldDefinition::create('integer')
      ->setLabel($this->t('Expiration Month'))
      ->setDescription($this->t('The expiration month.'))
      ->setSetting('size', 'tiny');

    $fields['card_exp_year'] = BundleFieldDefinition::create('integer')
      ->setLabel($this->t('Expiration Year'))
      ->setDescription($this->t('The expiration year.'))
      ->setSetting('size', 'small');

    return $fields;
  }

}
