<?php

namespace Drupal\commerce_webform_order\EventSubscriber;

use Drupal\commerce_order\Event\OrderEvent;
use Drupal\commerce_order\Event\OrderEvents;
use Drupal\commerce_webform_order\WebformSubmissionUpdaterTrait;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Listens to the order paid event.
 */
class OrderPaidSubscriber implements EventSubscriberInterface {

  use WebformSubmissionUpdaterTrait;

  /**
   * Constructs a new OrderPaidSubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(protected EntityTypeManagerInterface $entityTypeManager) {
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      OrderEvents::ORDER_PAID => ['onPaid', -9999],
    ];
  }

  /**
   * Load the webform submissions and update the payment status field.
   *
   * @param \Drupal\commerce_order\Event\OrderEvent $event
   *   The event.
   */
  public function onPaid(OrderEvent $event): void {
    $this->updateWebformSubmissionsPaymentStatusFromOrder($event->getOrder(), TRUE);
  }

}
