<?php

namespace Drupal\commerce_webform_order\EventSubscriber;

use Drupal\commerce_webform_order\WebformSubmissionUpdaterTrait;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\state_machine\Event\WorkflowTransitionEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Listens to the order state change event.
 */
class OrderTransitionSubscriber implements EventSubscriberInterface {

  use WebformSubmissionUpdaterTrait;

  /**
   * Constructs a new OrderTransitionSubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(protected EntityTypeManagerInterface $entityTypeManager) {
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      'commerce_order.post_transition' => ['onTransition', -9999],
    ];
  }

  /**
   * Load the webform submissions and update the order status field.
   *
   * @param \Drupal\state_machine\Event\WorkflowTransitionEvent $event
   *   The transition event.
   */
  public function onTransition(WorkflowTransitionEvent $event): void {
    /** @var \Drupal\commerce_order\Entity\OrderInterface $order */
    $order = $event->getEntity();
    $this->updateWebformSubmissionsOrderStateFromOrder($order, TRUE);
  }

}
