<?php

namespace Drupal\commerce_webform_order\Element;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Element;
use Drupal\webform\Element\WebformCompositeBase;

/**
 * Provides an order state element.
 *
 * @FormElement("commerce_webform_order_state")
 */
class OrderState extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  public static function getCompositeElements(array $element): array {
    $elements = [];
    $elements['workflow'] = [
      '#type' => 'value',
      '#title' => t('Workflow'),
    ];
    $elements['previous'] = [
      '#type' => 'value',
      '#title' => t('Previous state'),
    ];
    $elements['current'] = [
      '#type' => 'value',
      '#title' => t('Current state'),
    ];

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public static function processWebformComposite(&$element, FormStateInterface $form_state, &$complete_form): array {
    // Only process composite elements that are visible.
    if (isset($element['#initialize']) || !Element::isVisibleElement($element)) {
      return $element;
    }

    $element = parent::processWebformComposite($element, $form_state, $complete_form);
    if (!empty($element['#value']) && !empty($element['#value']['workflow']) && !empty($element['#value']['current'])) {
      /** @var \Drupal\state_machine\Plugin\Workflow\WorkflowInterface $workflow_definition */
      $workflow_definition = \Drupal::service('plugin.manager.workflow')->createInstance($element['#value']['workflow']);

      // Display order state label.
      // @todo Should we provide a select list of states instead?
      $element['#markup'] = $workflow_definition->getState($element['#value']['current'])->getLabel();
    }

    return $element;
  }

}
