<?php

namespace Drupal\commerce_webform_order\Element;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Element;
use Drupal\webform\Element\WebformCompositeBase;

/**
 * Provides a payment status element.
 *
 * @FormElement("commerce_webform_order_payment_status")
 */
class PaymentStatus extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  public static function getCompositeElements(array $element): array {
    $elements = [];
    $elements['previous'] = [
      '#type' => 'value',
      '#title' => t('Previous payment status'),
    ];
    $elements['current'] = [
      '#type' => 'value',
      '#title' => t('Current payment status'),
    ];
    $elements['total_paid_number'] = [
      '#type' => 'value',
      '#title' => t('Total paid (number)'),
    ];
    $elements['total_paid_currency_code'] = [
      '#type' => 'value',
      '#title' => t('Total paid (currency code)'),
    ];

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public static function processWebformComposite(&$element, FormStateInterface $form_state, &$complete_form): array {
    // Only process composite elements that are visible.
    if (isset($element['#initialize']) || !Element::isVisibleElement($element)) {
      return $element;
    }

    $element = parent::processWebformComposite($element, $form_state, $complete_form);
    if (!empty($element['#value']['previous'])) {
      // Display the payment status as a label.
      $element['#markup'] = t('Fully paid');
    }
    else {
      $element['#markup'] = t('Not fully paid');
    }

    return $element;
  }

}
