<?php

namespace Drupal\Tests\commerce_webform_order\Functional\Element;

use Drupal\Tests\commerce_webform_order\Functional\CommerceWebformOrderTestBase;

/**
 * Tests Commerce Webform Order: Order state element.
 *
 * @group commerce_webform_order
 */
class OrderStateTest extends CommerceWebformOrderTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'commerce_webform_order_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected static $testWebforms = [
    'cwo_test_order_transition',
  ];

  /**
   * Tests some of the methods.
   */
  public function testOrderState() {
    // Test as anonymous user.
    $this->drupalLogout();

    // Load the webform and get the submission form's submit path.
    $webform_storage = $this->entityTypeManager->getStorage('webform');
    /** @var \Drupal\webform\WebformInterface $webform */
    $webform = $webform_storage->load('cwo_test_order_transition');
    $webform_path = $webform->getSetting('page_submit_path');

    $this->drupalGet($webform_path);

    $edit = [
      'product' => $this->productVariations['ONE']->id(),
    ];
    $this->submitForm($edit, 'Submit');

    $webform_submission = $this->getLastSubmission($webform);
    /** @var \Drupal\commerce_order\Entity\OrderInterface $order */
    $order = $this->orderItemRepository->getLastByWebformSubmission($webform_submission, 'commerce_webform_order_handler')->getOrder();
    $stored_state = $webform_submission->getElementData('order_state');
    $this->assertEquals($stored_state['workflow'], $order->getState()->getWorkflow()->getId());
    // Each time the submission is loaded, the order state is updated with the
    // current order state, this way we do not trigger any action after save it.
    $current_state = $order->getState()->getId();
    $this->assertEquals($stored_state['previous'], $current_state);
    $this->assertEquals($stored_state['current'], $current_state);

    // Trigger an order transition and check the webform submission values.
    $transitions = $order->getState()->getWorkflow()->getPossibleTransitions($current_state);
    $transition = reset($transitions);
    $order->getState()->applyTransitionById($transition->getId());
    $order->save();

    $webform_submission = $this->reloadEntity($webform_submission);
    $order = $this->reloadEntity($order);
    $new_state = $order->getState()->getId();
    $this->assertNotEquals($new_state, $current_state);

    $stored_state = $webform_submission->getElementData('order_state');
    $this->assertEquals($stored_state['workflow'], $order->getState()->getWorkflow()->getId());
    // Each time the submission is loaded, the order state is updated with the
    // current order state, this way we do not trigger any action after save it.
    $this->assertEquals($stored_state['previous'], $new_state);
    $this->assertEquals($stored_state['current'], $new_state);
  }

}
