<?php

namespace Drupal\Tests\commerce_webform_order\Functional\Element;

use Drupal\Tests\commerce_webform_order\Functional\CommerceWebformOrderTestBase;

/**
 * Tests Commerce Webform Order: Payment status element.
 *
 * @group commerce_webform_order
 */
class PaymentStatusTest extends CommerceWebformOrderTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'commerce_webform_order_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected static $testWebforms = [
    'cwo_test_payment_status',
  ];

  /**
   * Tests some of the methods.
   */
  public function testPaymentStatus() {
    // Test as anonymous user.
    $this->drupalLogout();

    // Load the webform and get the submission form's submit path.
    $webform_storage = $this->entityTypeManager->getStorage('webform');
    /** @var \Drupal\webform\WebformInterface $webform */
    $webform = $webform_storage->load('cwo_test_payment_status');
    $webform_path = $webform->getSetting('page_submit_path');

    $this->drupalGet($webform_path);

    $edit = [
      'product' => $this->productVariations['ONE']->id(),
    ];
    $this->submitForm($edit, 'Submit');

    $webform_submission = $this->getLastSubmission($webform);
    /** @var \Drupal\commerce_order\Entity\OrderInterface $order */
    $order = $this->orderItemRepository->getLastByWebformSubmission($webform_submission, 'commerce_webform_order_handler')->getOrder();
    $stored_state = $webform_submission->getElementData('payment_status');
    $this->assertEmpty($stored_state['previous']);
    $this->assertEmpty($stored_state['current']);
    $this->assertEmpty($stored_state['total_paid_number']);
    $this->assertEmpty($stored_state['total_paid_currency_code']);

    // Trigger an order payment and check the webform submission values.
    $order->setTotalPaid($order->getTotalPrice());
    $order->save();

    $webform_submission = $this->reloadEntity($webform_submission);
    $order = $this->reloadEntity($order);
    $new_state = $webform_submission->getElementData('payment_status');
    $this->assertNotEquals($new_state['previous'], $stored_state['previous']);
    $this->assertNotEquals($new_state['current'], $stored_state['current']);
    $this->assertNotEquals($new_state['total_paid_number'], $stored_state['total_paid_number']);
    $this->assertNotEquals($new_state['total_paid_currency_code'], $stored_state['total_paid_currency_code']);

    $this->assertTrue((bool) $new_state['previous']);
    $this->assertTrue((bool) $new_state['current']);
    $this->assertEquals($new_state['total_paid_number'], $order->getTotalPaid()->getNumber());
    $this->assertEquals($new_state['total_paid_currency_code'], $order->getTotalPaid()->getCurrencyCode());
  }

}
