<?php

namespace Drupal\Tests\commerce_webform_order\Functional\WebformHandler;

use Drupal\Tests\commerce_webform_order\Functional\CommerceWebformOrderTestBase;

/**
 * Tests Commerce Webform Order handler: Source Entity.
 *
 * @group commerce_webform_order
 */
class CommerceWebformOrderHandlerSourceEntityTest extends CommerceWebformOrderTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'commerce_webform_order_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected static $testWebforms = [
    'cwo_test_source_entity_1',
    'cwo_test_source_entity_2',
  ];

  /**
   * Default source entity.
   *
   * In this test we are going to check the source entity feature when the
   * default source entity is used:
   *   After submit, the source entity should not be the order.
   */
  public function testDefaultSourceEntity() {
    // Test as anonymous user.
    $this->drupalLogout();

    $webform_submission = $this->postProductVariationToWebform('ONE', 'cwo_test_source_entity_1');
    /** @var \Drupal\commerce_order\Entity\OrderItemInterface $order_item */
    $order_item = $this->orderItemRepository->getLastByWebformSubmission($webform_submission, 'commerce_webform_order_handler');

    // The source entity of the submission is not the order.
    $this->assertNotEquals($order_item->getOrder()->getEntityTypeId(), $webform_submission->getSourceEntity()?->getEntityTypeId());
    $this->assertNotEquals($order_item->getOrderId(), $webform_submission->getSourceEntity()?->id());
  }

  /**
   * Overridden source entity.
   *
   * In this test we are going to check the source entity feature when the
   * override source entity is used:
   *   After submit, the source entity should be the order.
   */
  public function testOverriddenSourceEntity() {
    // Test as anonymous user.
    $this->drupalLogout();

    $webform_submission = $this->postProductVariationToWebform('ONE', 'cwo_test_source_entity_2');
    /** @var \Drupal\commerce_order\Entity\OrderItemInterface $order_item */
    $order_item = $this->orderItemRepository->getLastByWebformSubmission($webform_submission, 'commerce_webform_order_handler');

    // The source entity of the submission is the order.
    $this->assertEquals($order_item->getOrder()->getEntityTypeId(), $webform_submission->getSourceEntity()->getEntityTypeId());
    $this->assertEquals($order_item->getOrderId(), $webform_submission->getSourceEntity()->id());
  }

}
