<?php

namespace Drupal\yookassa\Helpers;

use Drupal;
use Drupal\Core\Database\Connection;
use Exception;

class YooKassaDatabaseHelper
{
    /**
     * Подключение к БД.
     *
     * @var Connection
     */
    protected $database;

    public function __construct()
    {
        $this->database = Drupal::database();
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getSuccessPaymentStat(): array
    {
        $queryPayments = $this->getAllPaymentMethods();

        if (empty($queryPayments)) {
            return [];
        }

        $machineName = [];
        foreach ($queryPayments as $paymentMethod) {
            $arrayPayment = unserialize($paymentMethod->data, ['allowed_classes' => false]);
            if ($arrayPayment['plugin'] === 'yookassa') {
                $machineName[] = $arrayPayment['id'];
            }
        }

        if (empty($machineName)) {
            return [];
        }

        $query = $this->database->select('commerce_payment', 'payments')
            ->condition('payments.remote_state', 'succeeded')
            ->condition('payments.amount__currency_code', 'RUB')
            ->condition('payments.payment_gateway', $machineName, 'IN');
        $query->addExpression('COUNT(`payment_id`)', 'count');
        $query->addExpression('SUM(`amount__number`)', 'total');

        return $query->execute()->fetchAssoc();
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getAllPaymentMethods(): array
    {
        return $this->database->select('config', 'configPayment')
            ->condition('name', 'commerce_payment.commerce_payment_gateway.%', 'LIKE')
            ->fields('configPayment', ['data'])
            ->execute()->fetchAll();
    }
}