(function (Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.commerceYotpo = Drupal.behaviors.commerceYotpo || {
    attach: function attach(context) {
      var settings = drupalSettings.commerceYotpo || {};
      var appKey = settings.appKey;
      if (!appKey || context !== document) {
        return;
      }

      if (document.querySelector('script[data-yotpo-app="' + appKey + '"]')) {
        return;
      }

      var script = document.createElement('script');
      script.async = true;
      script.src = 'https://staticw2.yotpo.com/' + appKey + '/widget.js';
      script.setAttribute('data-yotpo-app', appKey);
      document.head.appendChild(script);
    }
  };
})(Drupal, drupalSettings);
