<?php

declare(strict_types=1);

namespace Drupal\commerce_yotpo\Plugin\Block;

use Drupal\Component\Utility\Html;
use Drupal\Core\Cache\Cache;

/**
 * Provides the Yotpo bottom line widget.
 *
 * @Block(
 *   id = "commerce_yotpo_product_bottomline",
 *   admin_label = @Translation("Yotpo bottom line")
 * )
 */
class ProductBottomLineBlock extends YotpoBlockBase {

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    $build = $this->buildBaseRenderArray();
    if (!$build) {
      return [];
    }

    $product_data = $this->productDataBuilder->buildFromRoute($this->routeMatch);
    if (!$product_data) {
      return [];
    }

    $domain = Html::escape($this->getDomain());
    $product_id = Html::escape($product_data['product_id']);
    $name = Html::escape($product_data['name']);
    $url = Html::escape($product_data['url']);
    $image = Html::escape($product_data['image']);
    $description = Html::escape($product_data['description']);

    $build['#markup'] = '<div class="yotpo bottomLine"
      data-appkey="' . Html::escape($this->getAppKey() ?? '') . '"
      data-domain="' . $domain . '"
      data-product-id="' . $product_id . '"
      data-name="' . $name . '"
      data-url="' . $url . '"
      data-image-url="' . $image . '"
      data-description="' . $description . '"></div>';

    $build['#cache'] = [
      'max-age' => Cache::PERMANENT,
      'contexts' => ['route'],
    ];

    return $build;
  }

}
