<?php

declare(strict_types=1);

namespace Drupal\commerce_yotpo\Plugin\Block;

use Drupal\Core\Cache\Cache;

/**
 * Provides a block for the Yotpo testimonials widget.
 *
 * @Block(
 *   id = "commerce_yotpo_testimonials",
 *   admin_label = @Translation("Yotpo testimonials")
 * )
 */
class TestimonialsBlock extends YotpoBlockBase {

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    $build = $this->buildBaseRenderArray();
    if (!$build) {
      return [];
    }

    $build['#markup'] = '<div id="yotpo-testimonials-custom-tab"></div>';
    $build['#cache'] = [
      'max-age' => Cache::PERMANENT,
    ];

    return $build;
  }

}
