<?php

declare(strict_types=1);

namespace Drupal\commerce_zero_out_tax\OrderProcessor;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\commerce_order\OrderProcessorInterface;

/**
 * Clears the zero-out-tax flag at the start of each refresh cycle.
 *
 * The promotion offer will set it again when applicable.
 */
class ClearZeroOutTaxFlagProcessor implements OrderProcessorInterface {

  /**
   * {@inheritdoc}
   */
  public function process(OrderInterface $order): void {
    $order->unsetData('zero_out_tax');
  }

}
