<?php

/**
 * @file
 * Describes hooks usage for the commercetools module.
 */

use Drupal\commercetools\CommercetoolsUpdates;

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Recommended hook_update_N implementation.
 *
 * Avoid placing business logic here.
 * Instead, implement all code as static functions in helper classes
 * such as CommercetoolsUpdates, and call them from within the hook.
 *
 * @param array $sandbox
 *   Stores information for multi-pass updates. Optional using.
 *
 * @see https://www.drupal.org/i/3485835
 */
function commercetools_update_20000(&$sandbox) {
  CommercetoolsUpdates::migrateConfigKeys([
    'configuration_from.name:option_key' => 'configuration_to.name:option_key_new',
  ]);

  $configOptionsToUpdate = [
    'key' => 'new option value',
  ];
  CommercetoolsUpdates::setConfigKeys(
    $configOptionsToUpdate,
    'specific_config.name'
  );

  $configOptionsToDelete = [
    'option_key',
  ];
  CommercetoolsUpdates::clearConfigKeys($configOptionsToDelete);

  return t('Some commercetools configuration has been updated.');
}

/**
 * @} End of "addtogroup hooks".
 */
