/**
 * @file
 * The commercetools_content ajax functionality.
 */

(() => {
  Drupal.behaviors.CommercetoolsContentCarts = {
    attach(context) {
      const actionBtn = once(
        'CommercetoolsContentCarts',
        '[data-cart-action]',
        context,
      );

      // JS action buttons are hidden by default.
      actionBtn.forEach((btn) => btn.classList.remove('d-none'));

      actionBtn.forEach((btn) => {
        btn.addEventListener('click', (e) => {
          e.preventDefault();
          const { currentTarget } = e;
          const form = currentTarget.closest('form');
          const action = currentTarget.dataset.cartAction;
          // Run the cart action and submit the updated form.
          switch (action) {
            case 'plus-quantity':
            case 'minus-quantity': {
              const quantityInput = currentTarget.parentElement.querySelector(
                '.line-item-quantity',
              );
              const currentQuantity = parseInt(quantityInput.value, 10) || 0;
              quantityInput.value =
                action === 'plus-quantity'
                  ? currentQuantity + 1
                  : Math.max(0, currentQuantity - 1);
              quantityInput.dispatchEvent(
                new Event('change', { bubbles: true }),
              );
              break;
            }
            default: {
              const removeInput =
                currentTarget.parentElement.querySelector('.line-item-remove');
              if (removeInput) removeInput.value = 1;
              const updateButton = form.querySelector('.cart-update-button');
              if (updateButton) updateButton.click();
              break;
            }
          }
        });
      });

      const lineItemQuantities = once(
        'CommercetoolsContentCarts',
        '.line-item-quantity',
        context,
      );

      lineItemQuantities.forEach((lineItemQuantity) => {
        lineItemQuantity.addEventListener('change', (e) => {
          this.updateForm(e.currentTarget.closest('form'));
        });
      });
    },

    // Update form with a one-second delay to avoid multiple ajax requests.
    updateForm(form) {
      window.clearTimeout(this.delay);
      this.delay = window.setTimeout(() => {
        const updateButton = form.querySelector('.cart-update-button');
        if (updateButton) updateButton.click();
      }, 1000);
    },
  };
})();
