<?php

namespace Drupal\commercetools_content\Controller;

use Drupal\Component\Utility\UrlHelper;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\InsertCommand;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Render\Renderer;
use Drupal\Core\Routing\CurrentRouteMatch;
use Drupal\commercetools_content\Service\CommercetoolsAjaxHelper;
use Drupal\commercetools_content\Service\CommercetoolsHtmlRenderer;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Ajax controller.
 */
class CommercetoolsAjaxController extends ControllerBase {

  /**
   * Ajax clicked clink param.
   */
  protected const QUERY_URL_PARAM = 'target_url';

  /**
   * Commercetools renderer helper.
   *
   * @var \Drupal\commercetools_content\Service\CommercetoolsHtmlRenderer
   */
  protected CommercetoolsHtmlRenderer $ctRender;

  /**
   * Commercetools ajax helper.
   *
   * @var \Drupal\commercetools_content\Service\CommercetoolsAjaxHelper
   */
  protected CommercetoolsAjaxHelper $ajaxHelper;

  /**
   * Drupal renderer.
   *
   * @var \Drupal\Core\Render\Renderer
   */
  protected Renderer $renderer;

  /**
   * Route matcher.
   *
   * @var \Drupal\Core\Routing\CurrentRouteMatch
   */
  protected CurrentRouteMatch $routeMatch;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->ajaxHelper = $container->get('commercetools_content.ajax_helper');
    $instance->ctRender = $container->get('commercetools_content.html_renderer');
    $instance->renderer = $container->get('renderer');
    $instance->routeMatch = $container->get('current_route_match');
    return $instance;
  }

  /**
   * Render blocks via ajax.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   Request.
   *
   * @return \Drupal\Core\Ajax\AjaxResponse
   *   Ajax response.
   */
  public function __invoke(Request $request): AjaxResponse {
    $blocks = $request->query->get('blocks');
    $blocks = explode(',', $blocks);

    $targetUrl = UrlHelper::parse($request->query->all()[self::QUERY_URL_PARAM]);
    $targetUrl['path'] = str_replace($request->getBasePath(), '', $targetUrl['path']);
    $mainContent = $this->ajaxHelper->renderMainContentByPath($targetUrl);

    $renderResult = $this->ctRender->prepareRender($mainContent, $request, $this->routeMatch);

    $response = new AjaxResponse();

    foreach ($blocks as $id) {
      foreach ($renderResult[0] as $region => $content) {
        // Skip non-region render array items.
        if (str_starts_with($region, '#')) {
          continue;
        }
        if (isset($content[$id])) {
          $blockRender = $this->renderer->renderRoot($content[$id]);
          $response->addCommand(new InsertCommand('[' . CommercetoolsAjaxHelper::COMMERCETOOLS_BLOCK_ID . '="' . $id . '"]', $blockRender));
        }
      }
    }
    return $response;
  }

}
