<?php

namespace Drupal\commercetools_content\Controller;

use Drupal\commercetools\CommercetoolsProducts;
use Drupal\commercetools_content\Form\AddToCartForm;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Defines a controller for the Commercetools product pages.
 */
class CommercetoolsProductController extends ControllerBase {

  /**
   * The commercetools products service.
   *
   * @var \Drupal\commercetools\CommercetoolsProducts
   */
  protected CommercetoolsProducts $ctProducts;

  /**
   * The form builder.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected $formBuilder;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->ctProducts = $container->get('commercetools.products');
    $instance->formBuilder = $container->get('form_builder');
    return $instance;
  }

  /**
   * Displays a page with the details of a Commercetools product.
   *
   * @param string $slug
   *   The slug value of the product to search.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request object.
   *
   * @return array
   *   An array containing the output for the product page.
   */
  public function view(string $slug, Request $request): array {
    $productDetailsCacheable = $this->ctProducts->getProductBySlug($slug);
    $productDetails = $productDetailsCacheable->getData();
    $productDetails['current_sku'] = $request->query->get('sku');

    $output = [
      '#title' => $productDetails['name'],
      'form' => $this->formBuilder->getForm(AddToCartForm::class, $productDetails, 'full'),
    ];
    $cache = $productDetailsCacheable->getCacheableMetadata();
    $cache->addCacheContexts(['languages:language_content']);
    $cache->applyTo($output);
    return $output;
  }

}
