<?php

declare(strict_types=1);

namespace Drupal\commercetools_content\Plugin\Block;

use Drupal\Core\Cache\Cache;
use Drupal\Core\Url;
use Drupal\commercetools\Plugin\Block\CommercetoolsProductFiltersBlockBase;
use Drupal\commercetools_content\Form\ContentSettingsForm;
use Drupal\commercetools_content\Service\CommercetoolsAjaxHelper;
use Drupal\commercetools_content\Service\CommercetoolsContentComponents;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a product search block.
 *
 * @Block(
 *   id = "commercetools_content_product_filters",
 *   admin_label = @Translation("Product Filters"),
 * )
 */
class CommercetoolsContentProductFiltersBlock extends CommercetoolsProductFiltersBlockBase {

  /**
   * The commercetools content component service.
   *
   * @var \Drupal\commercetools_content\Service\CommercetoolsContentComponents
   */
  protected CommercetoolsContentComponents $contentComponents;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->contentComponents = $container->get('commercetools_content.content_components');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return parent::defaultConfiguration() + [
      'use_ajax' => TRUE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildSafe(): array {
    $targetPage = empty($this->configuration['target_page']) ? NULL : Url::fromUserInput($this->configuration['target_page']);
    $enabledFilters = $this->getEnabledFilters();
    $index = $this->configuration['product_list_index'];
    $build = $this->contentComponents
      ->getFiltersForm(
        (int) $this->configuration['product_list_index'],
        $targetPage,
        $enabledFilters,
        array_filter($enabledFilters, function ($filter) {
          return in_array($filter['widget_type'], ['facet', 'facet_count']);
        }),
      );

    $build['#attributes'][CommercetoolsAjaxHelper::COMMERCETOOLS_PRODUCT_INDEX] = $index;

    // Add ajax class if enabled.
    $this->configuration['use_ajax'] = TRUE;
    $build['#attributes']['class'][] = CommercetoolsAjaxHelper::COMMERCETOOLS_AJAX_CLASS;
    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheTags(): array {
    $cacheTags = parent::getCacheTags();
    return Cache::mergeTags($cacheTags, [
      'config:' . ContentSettingsForm::CONFIGURATION_NAME,
    ]);
  }

}
