<?php

namespace Drupal\commercetools_content;

/**
 * Defines the configuration for displaying a product list.
 */
class ProductListConfigurationDto {

  public function __construct(
    public ?string $style = 'cards',
    public ?int $itemsPerPage = NULL,
    public ?string $unavailableDataText = NULL,
    public ?array $filters = NULL,
    public ?array $facets = NULL,
    public ?string $search = NULL,
    public ?int $limit = NULL,
    public int $offset = 0,
    public ?string $sortBy = NULL,
    public ?string $sortOrder = NULL,
    public ?array $categories = NULL,
    public ?array $skus = NULL,
    public ?array $customFilters = NULL,
    public int $columnsNumber = 3,
  ) {
  }

  /**
   * Merge the product list configuration with the current configuration.
   *
   * @param ProductListConfigurationDto $configurationDto
   *   The product list configuration.
   */
  public function merge(ProductListConfigurationDto $configurationDto): void {
    $this->style = $configurationDto->style ?? $this->style;
    $this->itemsPerPage = $configurationDto->itemsPerPage ?? $this->itemsPerPage;
    $this->unavailableDataText = $configurationDto->unavailableDataText ?? $this->unavailableDataText;
    $this->filters = $this->filters && $configurationDto->filters
      ? array_merge_recursive($this->filters, $configurationDto->filters) : $configurationDto->filters;
    $this->facets = $this->facets && $configurationDto->facets ?
      $this->mergeFacetsByPath($configurationDto->facets)
      : $configurationDto->facets;
    $this->search = $configurationDto->search ?? $this->search;
    $this->limit = $configurationDto->limit ?? $this->limit;
    $this->offset = $configurationDto->offset ?? $this->offset;
    $this->sortBy = $configurationDto->sortBy ?? $this->sortBy;
    $this->sortOrder = $configurationDto->sortOrder ?? $this->sortOrder;
    $this->customFilters = $this->categories && $configurationDto->categories
      ? array_merge_recursive($this->categories, $configurationDto->categories) : $configurationDto->categories;
    $this->skus = $this->skus && $configurationDto->skus
      ? array_merge_recursive($this->skus, $configurationDto->skus) : $configurationDto->skus;
    $this->customFilters = $this->customFilters && $configurationDto->customFilters
      ? array_merge_recursive($this->customFilters, $configurationDto->customFilters) : $configurationDto->customFilters;
    $this->columnsNumber = $configurationDto->columnsNumber ?? $this->columnsNumber;
  }

  /**
   * Merge new facets by the facet path.
   */
  protected function mergeFacetsByPath(array $newFacets): array {
    $facetMap = [];

    // Index old facets by path.
    foreach ($this->facets as $facet) {
      $path = $facet['graphql']['model']['terms']['path'];
      $facetMap[$path] = $facet;
    }

    // Merge or overwrite with new facets.
    foreach ($newFacets as $facet) {
      $path = $facet['graphql']['model']['terms']['path'];
      if (isset($facetMap[$path])) {
        $facet[$path]['graphql']['model']['terms']['countProducts'] = $facetMap[$path]['graphql']['model']['terms']['countProducts']
          ?: $facet['graphql']['model']['terms']['countProducts'];
      }
      $facetMap[$path] = $facet;
    }

    return array_values($facetMap);
  }

}
