<?php

declare(strict_types=1);

namespace Drupal\Tests\commercetools_content\Unit;

use Drupal\commercetools\CommercetoolsProducts;
use Drupal\commercetools_content\Controller\CommercetoolsCatalogController;
use Drupal\commercetools_content\Service\CommercetoolsContentComponents;
use Drupal\commercetools_test\CommerceToolsTesting;
use Drupal\test_helpers\TestHelpers;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\HttpFoundation\Request;

/**
 * @coversDefaultClass \Drupal\commercetools_content\Controller\CommercetoolsCatalogController
 * @group commercetools
 */
class CommercetoolsCatalogControllerTest extends UnitTestCase {

  /**
   * @covers ::create
   * @covers ::view
   */
  public function testCatalog() {
    CommerceToolsTesting::getCommercetoolsService(__CLASS__ . '::' . __FUNCTION__);

    $request = Request::create('/catalog?page=1');
    TestHelpers::service('request_stack')->push($request);
    TestHelpers::service('pager.parameters', initService: TRUE);
    TestHelpers::service('pager.manager', initService: FALSE);
    TestHelpers::service('form_builder', initService: FALSE);
    $moduleDirectory = TestHelpers::getModuleRoot(CommercetoolsProducts::class);
    TestHelpers::service('commercetools.products', servicesYamlFile: $moduleDirectory . '/commercetools.services.yml', initService: TRUE);
    TestHelpers::service('messenger');
    TestHelpers::service('cache_contexts_manager');
    $moduleDirectory = TestHelpers::getModuleRoot(CommercetoolsContentComponents::class);
    TestHelpers::service('commercetools_content.content_components', servicesYamlFile: $moduleDirectory . '/commercetools_content.services.yml', initService: TRUE);
    // @todo Make the service work.
    TestHelpers::service('path.validator', initService: FALSE);
    $config = CommerceToolsTesting::getTestConfiguration('commercetools');
    TestHelpers::service('config.factory')->stubSetConfig('commercetools.settings', $config['commercetools.settings']);

    $controller = TestHelpers::createClass(CommercetoolsCatalogController::class);
    $build = $controller->view($request);
    foreach ($build['content']['#pre_render'] as $preRender) {
      $build['content'] = call_user_func_array($preRender, [$build['content']]);
    }

    $itemsPerPage = $config['commercetools.settings']['items_per_page'];
    $this->assertCount($itemsPerPage, $build['content']['catalog']['#items']);
    $this->assertEquals('commercetools_product_cards_item', $build['content']['catalog']['#items'][3]['#theme']);

    $this->assertEquals('pager', $build['content']['pager']['#type']);
  }

}
