class InputTextfield extends HTMLElement {
  connectedCallback() {
    const { name, label, disabled, defaultValue, required } = this.properties;
    const selector = name.replace(/\[(.*?)\]/g, '-$1');

    this.innerHTML = `
      <div class="form-item form-type-textfield form-item-${selector}">
        <label for="edit-${selector}" class="${required ? 'form-required' : ''}">${label}</label>
        <input type="text" id="edit-${selector}" name="${name}" value="${defaultValue}" size="60" maxlength="128" ${disabled ? 'disabled="disabled"' : ''} ${required ? 'required="required"' : ''} class="form-text form-control ${required ? 'required' : ''} ${disabled ? 'disabled' : ''}">
      </div>
    `;
  }
}

customElements.define('ct-input-textfield', InputTextfield);
