class CategoriesItemsBase extends HTMLElement {
  connectedCallback() {
    this.setAttributes();
    this.linkClickHandler = this.linkClickHandler.bind(this);
    this.renderComponent();
  }

  linkClickHandler(e) {
    e.preventDefault();

    const url = new URL(e.target.getAttribute('href'));
    this.cleanupDynamicQueryParamsByIndex(
      url,
      this.componentConfig.productListIndex,
    );

    const targetPage = this.componentConfig.targetPage.slice(1);

    if (targetPage.trim() !== '' && url.pathname !== Drupal.url(targetPage)) {
      url.pathname = Drupal.url(targetPage);
      window.location = url.toString();
    } else {
      window.history.pushState({ path: url.toString() }, '', url.toString());
    }

    window.commercetools.resetProductListResult(
      this.componentConfig.productListIndex,
    );
    const changeEvent = new CustomEvent('ct.filters.change', {
      detail: {
        productListIndex: this.componentConfig.productListIndex,
        newUrl: url,
      },
    });
    document.dispatchEvent(changeEvent);
  }

  // This method does not reference `this`, but is inherited classes use this method.
  // eslint-disable-next-line class-methods-use-this
  cleanupDynamicQueryParamsByIndex(url, index) {
    const paramsToRemove = window.commercetools.getRequestQueryParams(index);

    // Always remove the page parameter when changing filters or category.
    url.searchParams.delete('page');

    // eslint-disable-next-line no-restricted-syntax
    for (const [name, data] of Object.entries(paramsToRemove)) {
      if (name === 'filters') {
        // Remove all original filter parameters.
        data.originalKeys.forEach((originalKey) => {
          url.searchParams.delete(originalKey);
        });

        // Filter and rebuild only non-attribute filters.
        Object.entries(data.parsed.filters)
          .filter(
            ([filterKey]) => !filterKey.startsWith('variants.attributes.'),
          )
          .forEach(([filterKey, filterValue]) => {
            const paramName = `filters[${filterKey}]`;

            if (Array.isArray(filterValue)) {
              filterValue.forEach((value) =>
                url.searchParams.append(paramName, value),
              );
            } else {
              url.searchParams.set(paramName, filterValue);
            }
          });
      }
    }
  }

  // eslint-disable-next-line class-methods-use-this
  setAttributes() {
    throw new Error("Method 'setAttributes()' must be implemented.");
  }

  // eslint-disable-next-line class-methods-use-this
  renderComponent() {
    throw new Error("Method 'renderComponent()' must be implemented.");
  }
}

window.commercetools.CategoriesItemsBase = CategoriesItemsBase;
