class CartSummary extends HTMLElement {
  async connectedCallback() {
    this.total = 0;
    this.loading = true;
    this.maxItems = this.componentConfig.maxItems;
    this.cartPath = window.drupalSettings.commercetoolsDecoupled.cartPath;
    this.checkoutPath =
      window.drupalSettings.commercetoolsDecoupled.checkoutPath;
    this.render();
    document.addEventListener(
      'commercetoolsDecoupledCartUpdated',
      this.handleCartUpdated.bind(this),
    );
    const cart = await window.commercetools.getCart();
    this.total = cart?.lineItems?.length || 0;
    this.totalPrice = cart?.totalPrice.localizedPrice || false;
    this.loading = false;
    this.render();
  }

  handleCartUpdated(event) {
    this.total = event.detail.totalItems ?? '';
    this.render();
  }

  disconnectedCallback() {
    document.removeEventListener(
      'commercetoolsDecoupledCartUpdated',
      this.handleCartUpdated,
    );
  }

  render() {
    const cartBadge =
      this.total !== null && this.total > 0
        ? `<span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">${this.total}</span>`
        : '';

    const moreItemsLink =
      this.total > this.maxItems
        ? `<div class="text-center mt-2">
          <a href="${this.cartPath}" class="text-muted">
            ${this.total - this.maxItems} ${Drupal.t('more items')}
          </a>
        </div>`
        : '';

    const totalPrice =
      this.total > 0
        ? `<div class="my-2">
            <strong>${Drupal.t('Total price')}:</strong>
            ${this.loading ? CartSummary.placeholder(this.loading) : this.totalPrice}
        </div>`
        : '';

    const actionButtons =
      this.total > 0
        ? `<div class="d-flex">
            <a href="${this.cartPath}" class="btn btn-primary w-100">
              ${Drupal.t('View Cart')}
            </a>
        </div>`
        : '';

    this.innerHTML = `
      <div class="commercetools-summary-block dropdown" style="max-width: 32rem; ${this.loading ? 'cursor: progress' : ''}">
        <button
          class="btn btn-light position-relative"
          type="button"
          id="cartDropdown"
          data-bs-toggle="dropdown"
          aria-expanded="false"
        >
          <i class="bi bi-bag fs-4"></i>
          ${cartBadge}
        </button>
        <div
          class="dropdown-menu dropdown-menu-end p-3 shadow-lg"
          aria-labelledby="cartDropdown"
        >
          <div class="cart-items" style="max-height: 20rem; overflow-y: auto; overflow-x: hidden;">
            <ct-cart-info is-summary-cart="true"></ct-cart-info>
            ${moreItemsLink}
          </div>
          <div class="position-sticky bottom-0 bg-white">
            ${totalPrice}
            ${actionButtons}
          </div>
        </div>
      </div>
    `;
  }

  static placeholder() {
    return `<span class="placeholderify"><span style="color: initial;">${Drupal.t('Loading...')}</span></span>`;
  }
}

customElements.define('ct-cart-summary', CartSummary);
