class CategoriesLinksItems extends window.commercetools.CategoriesItemsBase {
  setAttributes() {
    this.listClasses = ['clearfix', 'flex-column', 'nav', 'nav-pills'];
    this.listItemClasses = ['nav-item'];
    this.listLinkClasses = ['nav-link'];

    if (this.loading) {
      this.listClasses.push('placeholderify');
    }
  }

  renderComponent() {
    const list = document.createElement('ul');
    list.classList.add(...this.listClasses);
    if (this.currentTreeLevel > 1) {
      list.classList.add(`ms-3`);
    } else {
      list.classList.add(`ms-0`);
    }

    const url = new URL(window.location);
    const paramName = window.commercetools.getParamNameByIndex(
      'category',
      this.componentConfig.productListIndex,
    );

    this.categoriesList.forEach((item) => {
      url.searchParams.set(paramName, item.id);
      const href = url.toString();
      const link = document.createElement('a');
      link.addEventListener('click', this.linkClickHandler);
      link.setAttribute('href', href);
      link.innerText = item.name;
      link.classList.add(...this.listLinkClasses);
      if (item?.is_active) {
        link.classList.add('active', 'ps-3');
      } else if (item?.in_active_trail) {
        link.classList.add('fw-bold');
      }

      const listItem = document.createElement('li');
      listItem.classList.add(...this.listItemClasses);
      listItem.appendChild(link);

      if (
        item.children.length > 0 &&
        (item?.in_active_trail ||
          !this.componentConfig.maxLevel ||
          this.currentTreeLevel < this.componentConfig.maxLevel)
      ) {
        const subTree = document.createElement('ct-categories-links-items');
        subTree.categoriesList = item.children;
        subTree.componentConfig = this.componentConfig;
        subTree.currentTreeLevel = this.currentTreeLevel + 1;
        listItem.appendChild(subTree);

        listItem.classList.add('menu-item--expanded');
      } else if (item.children.length > 0) {
        listItem.classList.add('menu-item--collapsed');
      }

      list.appendChild(listItem);
    });

    this.appendChild(list);
  }
}

customElements.define('ct-categories-links-items', CategoriesLinksItems);
