class GalleryModal extends HTMLElement {
  connectedCallback() {
    const selector = this.getSelector();
    this.innerHTML = `
      <div class="modal fade" id="${selector}" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">${this.title}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            </div>
          </div>
        </div>
      </div>
   `;
    this.querySelector('.modal-body').append(this.content);
  }

  getSelector() {
    if (this.selector) {
      this.selector = `ct-gallery-modal-${Math.random().toString(36).substring(2, 9)}`;
    }
    return this.selector;
  }
}

customElements.define('ct-gallery-modal', GalleryModal);
