class OrderCard extends HTMLElement {
  connectedCallback() {
    const placeholderOrder = {
      id: 0,
      orderNumber: '0000-0000',
      orderState: 'Open',
      subtotalPrice: { localizedPrice: '$1000' },
      lineItems: null,
    };
    const order = !this.order && this.isLoading ? placeholderOrder : this.order;
    const orderPath = `${drupalSettings.commercetoolsDecoupled.orderPathPrefix}/${order.id}`;

    this.innerHTML = `
      <div class="order${this.isLoading ? ' placeholderify' : ''} order-item mb-4 shadow ">
        <div class="order-item__header d-flex justify-content-between bg-secondary mb-4">
          <div class="col-md-4 order-item__header-number fs-5 p-3">
            <span>
              <span>Order item:</span>
              <a class="link-dark" href="${orderPath}">#${order.orderNumber ? order.orderNumber : ''}</a>
            </span>
          </div>
          <div class="col-md-4 text-center order-item__header-price fs-5 p-3 border-start border-end border-white"><span>${order.subtotalPrice.localizedPrice}</span></div>
          <div class="col-md-4 text-center  order-item__header-state fs-5 p-3"><span>${order.orderState}</span></div>
        </div>

      <div class="order-item__line-items container">

        <div class="row d-flex justify-content-between align-items-center">
          <div class="col-md-2 text-center fw-bold p-2">${Drupal.t('Image')}</div>
          <div class="col-md-5 fw-bold p-2">${Drupal.t('Product name')}</div>
          <div class="col-md-2 text-center fw-bold p-2">${Drupal.t('QTY')}</div>
          <div class="col-md-3 text-center fw-bold p-2">${Drupal.t('Subtotal')}</div>
        </div>

        <div class="order-line-items"></div>

      </div>
    </div>
    `;

    const LineItems = document.createElement('ct-line-items');
    LineItems.lineStyle = 'default';
    LineItems.initialLoad = this.initialLoad;
    LineItems.isLoading = this.isLoading;
    LineItems.lineItems = order.lineItems;

    this.querySelector('.order-line-items').append(LineItems);
  }
}

customElements.define('ct-order-card', OrderCard);
