class OrderDetails extends HTMLElement {
  connectedCallback() {
    this.renderComponent();
  }

  renderComponent() {
    const placeholderOrder = {
      id: 0,
      orderNumber: '0000-0000',
      orderState: 'Open',
      subtotalPrice: { localizedPrice: '$1000' },
      lineItems: null,
    };
    const order = !this.order && this.isLoading ? placeholderOrder : this.order;

    this.innerHTML = /* html */ `
      <div class="order order-page${this.isLoading ? ' placeholderify' : ''}">
        <div class="order-page__status fs-4 my-4">
          <span class="fw-bold">Order status:</span> <span>${order.orderState}</span>
        </div>
        <div class="order-page__line-items container shadow border">
          <div class="row d-flex justify-content-between align-items-center bg-secondary">
            <div class="col-md-2 text-center fw-bold p-2">${Drupal.t('Image')}</div>
            <div class="col-md-5 fw-bold p-2">${Drupal.t('Product name')}</div>
            <div class="col-md-2 text-center fw-bold p-2">${Drupal.t('QTY')}</div>
            <div class="col-md-3 text-center fw-bold p-2">${Drupal.t('Subtotal')}</div>
          </div>

          <div class="order-line-items"></div>
        </div>

        <div class="order-page__confirmation">
          <h2 class="fs-3 mt-4 text-center">${Drupal.t('Order Confirmation')}</h2>
          <div class="order-page__confirmation-blocks">
            <div class="row justify-content-between">

              <div class="order-page__confirmation-block col-md-4 my-4">
                <div class="order-confirmation--block-inner shadow border p-4">
                  <h3 class="fs-5">${Drupal.t('Shipping To')}</h3>
                  <hr/>
                  ${
                    order.shippingAddress
                      ? `
                    <h4 class="fs-6">${Drupal.t('Address')}</h4>
                    ${order?.shippingAddress?.firstName || ''} ${order?.shippingAddress?.lastName || ''}
                    <br/>
                    ${order.shippingAddress.streetName || ''}
                    <br/>
                    ${order.shippingAddress.state || ''},
                    ${order.shippingAddress.city || ''} ${order.shippingAddress.postalCode || ''}
                  `
                      : ''
                  }
                </div>
              </div>

            <div class="order-page__confirmation-block col-md-4 my-4">
              <div class="order-confirmation--block-inner shadow border p-4">
                <h3 class="fs-5">${Drupal.t('Billing Information')}</h3>
                <hr/>
                ${
                  order.billingAddress
                    ? `
                  <h4 class="fs-6">${Drupal.t('Address')}</h4>
                  ${order.billingAddress?.firstName || ''} ${order.billingAddress?.lastName || ''}
                  <br/>
                  ${order.billingAddress?.streetName || ''}
                  <br/>
                  ${order.billingAddress?.state || ''}, ${order.billingAddress?.city || ''} ${order.billingAddress?.postalCode || ''}
                `
                    : ''
                }
              </div>
            </div>

            <div class="order-page__confirmation-block col-md-4 my-4">
              <div class="order-confirmation--block-inner shadow border p-4">
                <h3 class="fs-5">${Drupal.t('Payment Information')}</h3>
                <hr/>
                <span class="fw-bold">${Drupal.t('Sub Total:')}</span>
                <span>${order.subtotalPrice.localizedPrice}</span>
                <br/>
                <span class="fw-bold">${Drupal.t('Shipping:')}</span>
                <span>${order?.shippingInfo?.shippingMethodName || ''} - ${order?.shippingInfo?.price.localizedPrice || ''}</span>

                ${
                  order?.taxedPrice?.taxPortions
                    .map((taxPortion) => {
                      return `
                    <br />
                    <span class="fw-bold">${taxPortion.name}</span> <span>${taxPortion.amount.localizedPrice}</span>`;
                    })
                    .join('') || ''
                }
                <br/>
                <span class="fw-bold">${Drupal.t('Total:')}</span>
                <span>${order?.taxedPrice?.totalGross.localizedPrice || ''}</span>
              </div>
            </div>

          </div>
          </div>
        </div>
      </div>
    `;

    const LineItems = document.createElement('ct-line-items');
    LineItems.lineStyle = 'default';
    LineItems.initialLoad = this.isLoading;
    LineItems.isLoading = this.isLoading;
    LineItems.lineItems = order.lineItems;
    console.log(LineItems.lineItems);
    this.querySelector('.order-line-items').append(LineItems);
  }
}

customElements.define('ct-order-details', OrderDetails);
