class ProductTitle extends HTMLElement {
  connectedCallback() {
    const placeholderProduct = {
      name: 'Placeholder for title',
      slug: 'placeholder-path',
      masterVariant: {
        images: [{ url: '' }],
        price: { localizedPrice: '$1000' },
      },
      isLoading: true,
    };
    const product = this.isLoading !== true ? this.product : placeholderProduct;
    this.name = product.name;
    if (!product.slug) {
      new Drupal.Message().add(
        'The product slug value is missing for a product.',
        { type: 'error' },
      );
    }
    this.path = Drupal.url(
      `${drupalSettings.commercetoolsDecoupled.catalogPath.substring(1)}/${product.slug}`,
    );

    this.price = product?.masterVariant?.price ?? {};
    this.isLoading = product.isLoading;

    const priceHtml = this.price?.discounted?.localizedPrice
      ? `<del>${this.price.localizedPrice ?? ''}</del>
         <span class="discount text-danger">${this.price.discounted.localizedPrice}</span>`
      : (this.price?.localizedPrice ?? '');

    this.innerHTML = /* html */ `
    <span class="${this.isLoading ? ' placeholderify' : ''}">
      <a class="text-decoration-none" href="${this.path}">
        <a class="text-decoration-none" href="${this.path}">
          ${this.name}${priceHtml ? ` - <span class="price">${priceHtml}</span>` : ''}
        </a>
      </a>
    </span>
    `;
  }

  setLoadingState(state = null) {
    const stateClasses = {
      load: 'placeholderify',
      reload: 'reloadify',
    };

    this.querySelectorAll('figure.card').forEach((card) => {
      card.classList.remove(...Object.values(stateClasses));
      const stateClass = stateClasses[state];
      if (state !== null && stateClass) {
        card.classList.add(stateClass);
      }
    });
  }
}

customElements.define('ct-product-title', ProductTitle);
