class CartInfo extends HTMLElement {
  async connectedCallback() {
    this.isLoading = true;
    this.renderComponent();
    this.isSummaryCart = this.getAttribute('is-summary-cart') === 'true';
    this.cart = await window.commercetools.getCart();
    this.isLoading = false;
    this.renderComponent();
  }

  renderComponent() {
    const cartForm = document.createElement('ct-cart-form');
    cartForm.isLoading = this.isLoading;
    cartForm.isSummaryCart = this.isSummaryCart;
    cartForm.cart = this.cart || {};
    this.replaceChildren(cartForm);
  }
}

customElements.define('ct-cart-info', CartInfo);
