class ProductInfo extends HTMLElement {
  async connectedCallback() {
    // Set current product variant.
    const url = new URL(window.location);
    this.currentSku = url.searchParams.get('sku') || null;

    this.isLoading = true;
    this.product = {};

    const headingElement = document.querySelector('h1');
    if (headingElement) {
      headingElement.style.display = 'none';
    }
    this.renderComponent();

    const slug = this.getAttribute('slug');
    try {
      this.product = await window.commercetools.getProductBySlug(slug);
      if (this.product === null) {
        this.renderNotFound();
        if (headingElement) {
          headingElement.style.display = 'block';
        }
        return;
      }
      this.product.currentSku = this.currentSku;
      const productName = this.product.name;

      if (headingElement) {
        headingElement.innerText = headingElement.innerText.replace(
          '[commercetools_product:name]',
          productName,
        );
        headingElement.style.display = 'block';
      }
      document.title = document.title.replace(
        '[commercetools_product:name]',
        productName,
      );
    } finally {
      this.isLoading = false;
      this.renderComponent();
    }
  }

  renderNotFound() {
    this.innerHTML = '';
    const notFound = document.createElement('ct-page-not-found');
    this.appendChild(notFound);
  }

  renderComponent() {
    const container = document.createElement('ct-product-details');
    this.product.isLoading = this.isLoading;
    container.product = this.product;
    this.innerHTML = '';
    this.appendChild(container);
  }
}

customElements.define('ct-product-info', ProductInfo);
