<?php

namespace Drupal\commercetools_decoupled\Form;

use Drupal\commercetools\Form\UiModuleSettingsFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure the Decoupled module settings.
 */
class DecoupledSettingsForm extends UiModuleSettingsFormBase {
  const CONFIGURATION_NAME = 'commercetools_decoupled.settings';
  const CONFIG_API_PROXY_PATH = 'api_proxy_path';
  const CONFIG_USE_DIRECT_CT_API_CONNECTIONS = 'use_direct_ct_api_connections';

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $form[self::CONFIG_API_PROXY_PATH] = $this->getFormElement(self::CONFIG_API_PROXY_PATH, [
      '#description' => $this->t('The module proxies all requests to the commercetools API through Drupal to add Drupal-specific access control, caching and other customizations. You can customize the Drupal API endpoint path, if needed. Example: <code>@example</code>.', [
        '@example' => '/commercetools-proxy',
      ]),
    ]);

    $form[self::CONFIG_USE_DIRECT_CT_API_CONNECTIONS] = $this->getFormElement(self::CONFIG_USE_DIRECT_CT_API_CONNECTIONS, [
      '#type' => 'checkbox',
      '#description' => $this->t('Allows using direct connections to commercetools API for fetching data on the frontend for safe queries. If disabled, Drupal handles and caches all commercetools API queries on the backend. Creates an anonymous access token to handle frontend connection. Depending on the commercetools API performance, this option can increase or decrease the page load time.'),
    ]);

    return $form;
  }

}
