<?php

namespace Drupal\commercetools_decoupled\Routing;

use Drupal\commercetools\CommercetoolsApiServiceInterface;
use Drupal\commercetools\Routing\UiModulesRouteProviderBase;
use Drupal\commercetools_decoupled\Controller\CommercetoolsApiController;
use Drupal\commercetools_decoupled\Controller\DecoupledPagesController;
use Drupal\commercetools_decoupled\Form\DecoupledSettingsForm;
use Symfony\Component\Routing\Route;

/**
 * Defines dynamic routes.
 */
class RouteProvider extends UiModulesRouteProviderBase {
  const CONFIGURATION_NAME = DecoupledSettingsForm::CONFIGURATION_NAME;
  const ROUTE_PREFIX = 'commercetools_decoupled.';

  const PAGE_API_PROXY = 'commercetools.api_proxy';

  const ROUTE_CONTROLLERS = [
    self::PAGE_CATALOG_ROUTE => DecoupledPagesController::class . '::productCatalog',
    self::PAGE_PRODUCT_ROUTE => DecoupledPagesController::class . '::productPage',
    self::PAGE_CART_ROUTE => DecoupledPagesController::class . '::cartPage',
    self::PAGE_USER_ORDER_ROUTE => DecoupledPagesController::class . '::orderViewPage',
    self::PAGE_USER_ORDERS_ROUTE => DecoupledPagesController::class . '::ordersViewPage',
    self::PAGE_CHECKOUT_ROUTE => DecoupledPagesController::class . '::checkoutPage',
    self::PAGE_RESET_CART_ROUTE => DecoupledPagesController::class . '::resetCart',
  ];

  /**
   * Returns an array of route objects.
   *
   * @return \Symfony\Component\Routing\RouteCollection
   *   An array of route objects.
   */
  public function routes() {
    $routeCollection = parent::routes();

    $config = $this->configFactory->get(self::CONFIGURATION_NAME);
    $basePath = $config->get(DecoupledSettingsForm::CONFIG_API_PROXY_PATH) ?: CommercetoolsApiServiceInterface::API_PROXY_PATH_DEFAULT;
    $path = $basePath . '/{projectId}/graphql';
    $route = new Route($path);
    $route->setDefault('_controller', CommercetoolsApiController::class . '::apiProxyGraphql');
    $route->setRequirement('_access', 'TRUE');
    $route->setRequirement('_format', 'commercetools_graphql');
    $routeCollection->add(self::PAGE_API_PROXY, $route);

    return $routeCollection;
  }

}
