const getBeforeAfterFunctions = require('../../../../../../tests/src/Nightwatch/Lib/getBeforeAfterFunctions');
const storeSetup = require('../../../../../../tests/src/Nightwatch/Lib/storeSetup');
const storeIsSetup = require('../../../../../../tests/src/Nightwatch/Lib/storeIsSetup');

module.exports = {
  ...getBeforeAfterFunctions(__filename, { skipDrupalLogsErrorCheck: true }),

  'Check decoupled catalog reflects a Store localization': (browser) => {
    let settings = {
      language: 'en',
      priceCurrency: 'EUR',
      priceCountry: 'DE',
    };
    storeSetup(browser, settings);
    storeIsSetup(browser, settings, (settingsMatch) => {
      browser.assert.equal(
        settingsMatch,
        true,
        'Store price localized: DE - EUR',
      );
    });

    settings = {
      language: 'en',
      priceCurrency: 'USD',
      priceCountry: 'US',
    };
    storeSetup(browser, settings);
    storeIsSetup(browser, settings, (settingsMatch) => {
      browser.assert.equal(
        settingsMatch,
        true,
        'Store price localized: US - USD',
      );
    });

    browser.end();
  },
};
