<?php

namespace Drupal\commercetools\Cache;

use Drupal\commercetools\CommercetoolsApiServiceInterface;
use Drupal\commercetools\CommercetoolsService;
use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Cache\CacheableResponseTrait;

/**
 * Defines a CacheableCommercetoolsGraphQlResponse class.
 */
final class CacheableCommercetoolsGraphQlResponse {
  use CacheableResponseTrait;

  const CACHE_TAG_GENERAL = 'commercetools';
  const CACHE_TAG_CONFIGURATION = 'config:' . CommercetoolsService::CONFIGURATION_NAME;
  const CACHE_TAG_API_CONFIGURATION = 'config:' . CommercetoolsApiServiceInterface::CONFIGURATION_NAME;
  const CACHE_TAG_PRODUCT = 'commercetools_product';
  const CACHE_TAG_PRODUCT_LIST = 'commercetools_product_list';
  const CACHE_TAG_CART_PREFIX = 'commercetools_cart:';
  const CACHE_TAG_ORDERS_PREFIX = 'commercetools_orders:';
  const CACHE_TAG_PRODUCT_PREFIX = 'commercetools_product:';
  const CACHE_TAG_CUSTOMER_PREFIX = 'commercetools_customer:';
  const CACHE_TAG_CATEGORY_LIST = 'commercetools_category_list';

  /**
   * Constructs the new CacheableCommercetoolsGraphQlResponse object.
   *
   * @param array $data
   *   A data to include.
   */
  public function __construct(
    protected array $data,
  ) {}

  /**
   * Creates a CacheableCommercetoolsGraphQlResponse from a cached object.
   *
   * @param mixed $object
   *   The object returned by cache backend.
   *   It usually contains 'data', 'tags' and 'expire' attributes, which
   *   are used to form a response and its cache metadata.
   *
   * @return static
   */
  public static function createFromCachedObject(mixed $object): self {
    $instance = new self($object->data ?? []);
    $cacheMetadata = new CacheableMetadata();
    $cacheMetadata->addCacheTags($object->tags ?? []);
    $cacheMetadata->mergeCacheMaxAge($object->expire ?? 0);
    $instance->addCacheableDependency($cacheMetadata);
    return $instance;
  }

  /**
   * Gets the included data.
   *
   * @return array
   *   The data array.
   */
  public function getData(): array {
    return $this->data;
  }

}
