<?php

namespace Drupal\commercetools\EventSubscriber;

use Drupal\commercetools\CommercetoolsApiServiceInterface;
use Drupal\commercetools\CookieStorageBase;
use Drupal\Core\Datetime\DrupalDateTime;

/**
 * The storage service that serves session ID as symfony cookie.
 */
class CommercetoolsSessionIdStorage extends CookieStorageBase {

  const COOKIE_NAME_PREFIX = 'CT_SESSION_';

  const COOKIE_EXPIRE_TIME_DELTA = 864000;

  /**
   * The cookie expire time.
   *
   * @var int
   */
  protected $expireTime = 0;

  /**
   * Sets the cookie expire time.
   *
   * @param string $datetime
   *   The cookie expire datetime from API response.
   */
  public function setExpireTime(string $datetime): void {
    $value = new DrupalDateTime($datetime);
    $this->expireTime = $value->getTimestamp();
  }

  /**
   * {@inheritdoc}
   */
  public function getCookieName(): string {
    $config = $this->configFactory
      ->get(CommercetoolsApiServiceInterface::CONFIGURATION_NAME);
    $key = $config->get(CommercetoolsApiServiceInterface::CONFIG_PROJECT_KEY);
    return self::COOKIE_NAME_PREFIX . sha1($key);
  }

  /**
   * {@inheritdoc}
   */
  protected function getExpireTime(): int {
    return $this->expireTime ?? $this->time->getRequestTime() + self::COOKIE_EXPIRE_TIME_DELTA;
  }

}
