<?php

namespace Drupal\commercetools\Exception;

use Commercetools\Base\MapperSequence;

/**
 * The exception on an unexpected error with a requests to commercetools API.
 */
class CommercetoolsGraphqlErrorException extends \RuntimeException {

  /**
   * Error messages.
   *
   * @var array
   */
  protected $messages = [];

  /**
   * {@inheritdoc}
   */
  public function __construct(?MapperSequence $errors = NULL, ?string $query = NULL, ?array $variables = NULL, ?\Throwable $previous = NULL) {
    foreach ($errors as $error) {
      $message = $error->getMessage();
      $code = method_exists($error, 'getCode') ? $error->getCode() : NULL;
      $messages[] = (empty($code) || $code == $message)
      ? $message
      : "$code: $message";
    }
    $this->messages = $messages;
    $message = implode("\n", $messages);
    // Commercetools returns code as string, that is not supported by PHP
    // exceptions, so adding it to the message and use 0 as code.
    $code = 0;
    parent::__construct($message, $code, $previous);
  }

  /**
   * Returns error messages.
   */
  public function getMessages() : array {
    return $this->messages;
  }

}
