<?php

namespace Drupal\commercetools\Exception;

/**
 * The exception on an unexpected error with a requests to commercetools API.
 */
class CommercetoolsOperationFailedException extends \RuntimeException {

  /**
   * {@inheritdoc}
   */
  public function __construct(?string $message = NULL, ?int $code = NULL, ?\Throwable $previous = NULL) {
    $message = "The commercetools API operation failed: " . ($message ?? 'Unexpected error.');
    $code ??= 0;
    parent::__construct($message, $code, $previous);
  }

}
