<?php

namespace Drupal\commercetools;

use Drupal\commercetools\Annotation\SubscriptionDestinationType as SubscriptionDestinationTypeAnnotation;
use Drupal\commercetools\Attribute\SubscriptionDestinationType as SubscriptionDestinationTypeAttribute;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * A plugin manager for subscriptions destination.
 */
class SubscriptionsDestinationPluginManager extends DefaultPluginManager {

  /**
   * {@inheritdoc}
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      subdir: 'Plugin/commercetools/SubscriptionDestinationType',
      namespaces: $namespaces,
      module_handler: $module_handler,
      plugin_interface: SubscriptionDestinationTypeInterface::class,
      plugin_definition_attribute_name: SubscriptionDestinationTypeAttribute::class,
      plugin_definition_annotation_name: SubscriptionDestinationTypeAnnotation::class,
    );

    $this->alterInfo('commercetools_subscription_destination_type');

    $this->setCacheBackend($cache_backend, 'commercetools_subscription_destination_type', ['commercetools_subscription_destination_type']);
  }

}
